

<?php $__env->startSection('title', 'Packages'); ?>

<?php $__env->startSection('content'); ?>
<div class="users-management">
    <div class="users-header">
        <h2>Packages</h2>
        <div class="users-actions">
            <a href="<?php echo e(route('admin.packages.servers')); ?>" class="btn btn-info">
                <i class="fas fa-server"></i> Manage Servers
            </a>
            <a href="<?php echo e(route('admin.packages.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add Package
            </a>
        </div>
    </div>
    
    <div class="dashboard-card">
        <div class="dashboard-card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Order</th>
                            <th>Image</th>
                            <th>Name</th>
                            <th>Price</th>
                            <th>Type</th>
                            <th>Stock</th>
                            <th>Subscription</th>
                            <th>Status</th>
                            <th>Servers</th>
                            <th>Sales</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="<?php echo e($package->isSoldOut() ? 'sold-out-row' : ''); ?>">
                            <td><?php echo e($package->sort_order); ?></td>
                            <td>
                                <?php if($package->image_path): ?>
                                    <img src="<?php echo e(asset('storage/' . $package->image_path)); ?>" alt="<?php echo e($package->name); ?>" class="package-thumbnail">
                                <?php else: ?>
                                    <div class="no-image">No Image</div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="package-name-cell">
                                    <?php echo e($package->name); ?>

                                    <?php if($package->isSoldOut()): ?>
                                        <span class="badge badge-danger">SOLD OUT</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td><?php echo e(currency_symbol(config_value('store_currency', 'GBP'))); ?><?php echo e(number_format($package->price, 2)); ?></td>
                            <td><?php echo e(ucfirst($package->type)); ?></td>
                            
                            <!-- Stock Column -->
                            <td>
                                <?php if($package->stock_enabled): ?>
                                    <div class="stock-cell">
                                        <div class="stock-progress">
                                            <div class="stock-progress-bar <?php echo e($package->stock_badge_class); ?>" 
                                                style="width: <?php echo e($package->stock_percentage); ?>%"></div>
                                        </div>
                                        <small class="text-muted"><?php echo e($package->stock_remaining); ?> / <?php echo e($package->stock_quantity); ?></small>
                                    </div>
                                <?php else: ?>
                                    <span class="text-muted"><i class="fas fa-infinity"></i> Unlimited</span>
                                <?php endif; ?>
                            </td>
                            
                            <!-- Subscription Column -->
                            <td>
                                <?php if($package->is_subscription): ?>
                                    <div class="subscription-cell">
                                        <span class="badge badge-subscription">
                                            <i class="fas fa-calendar-alt"></i>
                                            <?php echo e($package->subscription_duration_human); ?>

                                        </span>
                                        <small class="text-muted d-block"><?php echo e($package->subscription_duration); ?> days</small>
                                    </div>
                                <?php else: ?>
                                    <span class="text-muted">One-time</span>
                                <?php endif; ?>
                            </td>
                            
                            <td>
                                <span class="user-role <?php echo e($package->is_active ? 'role-moderator' : 'role-user'); ?>">
                                    <?php echo e($package->is_active ? 'Active' : 'Inactive'); ?>

                                </span>
                            </td>
                            <td>
                                <?php if($package->servers->count() > 0): ?>
                                    <div class="server-tags">
                                        <?php $__currentLoopData = $package->servers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $server): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="server-tag"><?php echo e($server->name); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php else: ?>
                                    <span class="text-server-info">All Servers</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="sales-cell">
                                    <strong><?php echo e($package->transactions()->where('status', 'completed')->count()); ?></strong>
                                </div>
                            </td>
                            <td class="user-actions">
                                <a href="<?php echo e(route('admin.packages.edit', $package)); ?>" class="btn-icon btn-primary" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="<?php echo e(route('store.show', $package->slug)); ?>" target="_blank" class="btn-icon btn-info" title="View Package">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <form action="<?php echo e(route('admin.packages.destroy', $package)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn-icon btn-danger" onclick="return confirm('Are you sure you want to delete this package?')" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="11" class="text-center">
                                <div class="empty-state">
                                    <i class="fas fa-box-open"></i>
                                    <h4>No Packages Found</h4>
                                    <p>Create your first package to get started.</p>
                                    <a href="<?php echo e(route('admin.packages.create')); ?>" class="btn btn-primary">
                                        <i class="fas fa-plus"></i> Create Package
                                    </a>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.sold-out-row {
    opacity: 0.6;
    background: rgba(220, 53, 69, 0.05);
}

.package-name-cell {
    display: flex;
    align-items: center;
    gap: 8px;
}

.badge {
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 0.75rem;
    font-weight: 600;
}

.badge-danger {
    background: #dc3545;
    color: #fff;
}

.badge-subscription {
    background: rgba(111, 66, 193, 0.2);
    color: #6f42c1;
    padding: 6px 10px;
    border-radius: 6px;
    display: inline-flex;
    align-items: center;
    gap: 5px;
}

.stock-cell {
    min-width: 120px;
}

.stock-info {
    margin-bottom: 6px;
}

.stock-badge {
    display: inline-flex;
    align-items: center;
    gap: 5px;
    padding: 4px 10px;
    border-radius: 6px;
    font-size: 0.85rem;
    font-weight: 600;
}

.stock-badge.in-stock,
.stock-badge.unlimited {
    background: rgba(40, 167, 69, 0.2);
    color: #28a745;
}

.stock-badge.medium-stock {
    background: rgba(23, 162, 184, 0.2);
    color: #17a2b8;
}

.stock-badge.low-stock {
    background: rgba(255, 193, 7, 0.2);
    color: #856404;
}

.stock-badge.sold-out {
    background: rgba(220, 53, 69, 0.2);
    color: #dc3545;
}

.stock-progress {
    height: 6px;
    background: rgba(0, 0, 0, 0.1);
    border-radius: 3px;
    overflow: hidden;
    margin-bottom: 4px;
}

.stock-progress-bar {
    height: 100%;
    transition: width 0.3s ease;
}

.stock-progress-bar.in-stock,
.stock-progress-bar.unlimited {
    background: #28a745;
}

.stock-progress-bar.medium-stock {
    background: #17a2b8;
}

.stock-progress-bar.low-stock {
    background: #ffc107;
}

.stock-progress-bar.sold-out {
    background: #dc3545;
}

.subscription-cell {
    text-align: center;
}

.sales-cell {
    text-align: center;
}

.sales-cell strong {
    font-size: 1.1rem;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/admin/packages/index.blade.php ENDPATH**/ ?>